// $Id: CTempoShiftPanel.cpp,v 1.5 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CTempoShiftPanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CTempoShiftPanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CTempoShiftPanel, CControlPanel);

//	===========================================================================
CTempoShiftPanel::CTempoShiftPanel(IControlRoot *root, const long uniqueId, const CRect &area)
                : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
                , m_tempoShiftBpmEditBox(NULL)
                , m_tempoShiftShiftEditBox(NULL)
                , m_tempoShiftOutputValueLabel(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CTempoShiftPanel);

	this->onDrawDrawThePanelBounds(false);

	// BPM edit
	m_tempoShiftBpmEditBox			= new CTextEdit(this,  e_tempoShiftBpmEditBox,		      CSCalWindow::CSCALWINDOW_CONTROL1_RECT, "120.00", this);
	m_tempoShiftShiftEditBox		= new CTextEdit(this,  e_tempoShiftShiftEditBox,		  CSCalWindow::CSCALWINDOW_CONTROL2_RECT, "12.00", this);
	m_tempoShiftOutputValueLabel	= new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);

	// Reference
	m_tempoShiftBpmEditBox->referenced();
	m_tempoShiftShiftEditBox->referenced();
	m_tempoShiftOutputValueLabel->referenced();

	// Set the format
	m_tempoShiftBpmEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_tempoShiftShiftEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_tempoShiftOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);

	m_tempoShiftBpmEditBox->setAlignment(CTextEdit::e_center);
	m_tempoShiftShiftEditBox->setAlignment(CTextEdit::e_center);

	// Make single click editable
	m_tempoShiftBpmEditBox->setSingleClickEditable();
	m_tempoShiftShiftEditBox->setSingleClickEditable();

	// Colours
	m_tempoShiftBpmEditBox->setColours(			CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_tempoShiftShiftEditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_tempoShiftOutputValueLabel->setColours(	CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);

	// Add controls
	this->addControl(m_tempoShiftBpmEditBox);
	this->addControl(m_tempoShiftShiftEditBox);
	this->addControl(m_tempoShiftOutputValueLabel);

	// Compute
	this->computeTempoShift();
}

//	===========================================================================
CTempoShiftPanel::~CTempoShiftPanel()
{
	EXPONENT_CLASS_DESTRUCTION(CTempoShiftPanel);

	FORGET_COUNTED_OBJECT(m_tempoShiftBpmEditBox);
	FORGET_COUNTED_OBJECT(m_tempoShiftShiftEditBox);
	FORGET_COUNTED_OBJECT(m_tempoShiftOutputValueLabel);
}

//	===========================================================================
void CTempoShiftPanel::handleActionEvent(const CActionEvent &event)
{
	switch(event.getControl()->getUniqueId())
	{
		case e_tempoShiftBpmEditBox:
		case e_tempoShiftShiftEditBox:
			this->computeTempoShift();
		break;
	}
}

//	===========================================================================
void CTempoShiftPanel::computeTempoShift()
{
	double bpm = CString::toDouble(m_tempoShiftBpmEditBox->getString().getString());
	
	if (bpm <= 0.0 || bpm >= 1000.0)
	{
		CDialog::notifyUser("Bpm range error!\n\n0.0 < bpm < 1000.0\n\nBpm must be between 0 and 1000 bpm", "SCal error", true);
		bpm = 120.0;
		m_tempoShiftBpmEditBox->setText("120.00");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", bpm);
		m_tempoShiftBpmEditBox->setText(string);
	}
	m_tempoShiftBpmEditBox->update();

	double shift = CString::toDouble(m_tempoShiftShiftEditBox->getString().getString());

	if (shift < -127.0 || shift > 127.0)
	{
		CDialog::notifyUser("Shift range error\n\n-127 < shift < 127\n\nShift must be between -127 and +127", "SCal error", true);
		shift = 12.0;
		m_tempoShiftShiftEditBox->setText("12.00");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", shift);
		m_tempoShiftShiftEditBox->setText(string);
	}
	m_tempoShiftShiftEditBox->update();

	CString output;
	output.setStringWithFormat("%0.02f", CMusicMath::getNewTempoPitchShift(shift, bpm));
	m_tempoShiftOutputValueLabel->setText(output);
	m_tempoShiftOutputValueLabel->update();
}